﻿//////////////////////////////////////////////
// EffectManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class Effect ;
	class System ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

#include "EffectType.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT EffectManager final : public nkCommon::MaybeSingletonClass<EffectManager>
	{
		public :

			// Management
			Effect* createOrRetrieve (nkMemory::StringView name, EFFECT_TYPE type) ;
			Effect* record (nkMemory::StringView name, nkMemory::UniquePtr<Effect> resource) ;
			Effect* get (nkMemory::StringView name) ;
			Effect* getByIndex (unsigned int id) ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<Effect> relinquish (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor, destructor
			EffectManager (bool isSingleton) noexcept ;
			EffectManager (System* system) noexcept ;
			EffectManager (const EffectManager&) = delete ;
			EffectManager (EffectManager&&) = delete ;
			virtual ~EffectManager () ;

			// Operators
			EffectManager& operator= (const EffectManager&) = delete ;
			EffectManager& operator= (EffectManager&&) = delete ;

		private :

			// Attributes
			System* _system ;

			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<Effect>> _memory ;

		private :

			friend class nkCommon::MaybeSingletonClass<EffectManager> ;
			friend class System ;
	} ;
}